import { clamp, editHistory, keys, xmlhttp } from "./util.js";


const CANVSIZE=256;
const canv1 = document.getElementById("imgcanv");
const canv2 = document.getElementById("drawcanv");
const ctx1 = canv1.getContext("2d")
const ctx2 = canv2.getContext("2d")
canv1.width = canv2.width = CANVSIZE;
canv1.height = canv2.height = CANVSIZE;
window.keys = keys;


let draworig = ctx2.getImageData(0,0,CANVSIZE,CANVSIZE);
let draw = ctx2.getImageData(0,0,CANVSIZE,CANVSIZE)
document.draw=draw
let rect = canv2.getBoundingClientRect();
console.log(rect)
/**
 * 
 * @param {MouseEvent} ev 
 */
let color = 128
let history = new editHistory()

document.onwheel = (ev)=>{
  color += ev.deltaY/10;
  color = clamp(color, 0, 255);
}

function setPixel(offset,c,log=true){
  if(offset<0 || offset>draw.data.length) return;
  if(log)history.append(offset, draw.data[offset]);
  draw.data[offset] = c;
  draw.data[offset+1]=c;
  draw.data[offset+2]=c;
  let x=(offset>>2)%CANVSIZE;
  let y=((offset>>2)-x)/CANVSIZE;
  ctx2.putImageData(draw,0,0,x,y,1,1)
}

canv2.onmousemove = (ev)=>{
  rect = canv2.getBoundingClientRect();
  let x=ev.clientX-rect.x; 
  let y=ev.clientY-rect.y
  let offset = 4*(x+CANVSIZE*y);
  if(keys.KeyS)setPixel(offset,color);
  if(keys.KeyD){
    for(let i=x-2; i<=x+2; i++){
      for(let j=y-2; j<=y+2; j++){
        setPixel(4*(i+CANVSIZE*j),draworig.data[offset]);
      }
    }
  }
}
function resetDrawCanv(arr){
  history = new editHistory()
  window.hist = history;
  rect = canv2.getBoundingClientRect();
  for(let i=0; i<CANVSIZE; i++){
    for(let j=0; j<CANVSIZE; j++){
      let idx = i*CANVSIZE+j
      draw.data[4*idx+0]=arr[idx]*255;
      draw.data[4*idx+1]=arr[idx]*255;
      draw.data[4*idx+2]=arr[idx]*255;
      draw.data[4*idx+3]=255;
    }
  }
  ctx2.putImageData(draw, 0, 0);
  draworig = ctx2.getImageData(0,0,CANVSIZE,CANVSIZE);
}

function resetMainCanv(arr){
  let dat = ctx1.getImageData(0,0,CANVSIZE,CANVSIZE)
  console.log(dat);
  for(let i=0; i<CANVSIZE; i++){
    for(let j=0; j<CANVSIZE; j++){
      let idx = i*CANVSIZE+j
      dat.data[4*idx+0]=arr[idx]*255;
      dat.data[4*idx+1]=arr[idx]*255;
      dat.data[4*idx+2]=arr[idx]*255;
      dat.data[4*idx+3]=255;
    }
  }
  //console.log(dat)
  ctx1.putImageData(dat, 0, 0);
}
function showKernSize(aug, w,h){
  let dat = ctx1.getImageData(0,0,CANVSIZE,CANVSIZE)
  for(let i=CANVSIZE/2-w; i<=CANVSIZE/2+w; i++){
    for(let j=CANVSIZE/2-h; j<=CANVSIZE/2+h; j++){
      let idx = i+j*CANVSIZE
      dat.data[4*idx] = dat.data[4*idx+1]+aug
    }
  }
  console.log("here")
  ctx1.putImageData(dat, 0,0);
}
window.showKernSize = showKernSize;

let lastSet
function setVisibility(dr=null){
  dr??=!lastSet
  canv2.style.display = dr?"block":"none"
  canv1.style.display = dr?"none":"block"
  lastSet=dr;
}
setVisibility(false)
keys.on.Space.add(()=>setVisibility(null));

function doCommunic(res = null){
  xmlhttp(res==null?"/reset":"/ret", "POST",{
    body:res,
    cb: (e,r)=>{
      const a = new Float32Array(r, 0, CANVSIZE*CANVSIZE)
      const b = new Float32Array(r, CANVSIZE*CANVSIZE*4, CANVSIZE*CANVSIZE)
      window.a=a
      console.log(a)
      console.log(b)
      resetMainCanv(a)
      resetDrawCanv(b)
    }
  })
}

keys.on.Q.add(()=>{
  doCommunic(null)
})
keys.on.E.add(()=>{
  let c = new Float32Array(CANVSIZE*CANVSIZE)
  for(let i=0; i<CANVSIZE*CANVSIZE; i++){
    c[i]=draw.data[i*4]/255
  }
  doCommunic(c.buffer)
})

keys.on.Z.add((ev)=>{
  if(ev.ctrlKey){
    console.log("undoing");
    let arr = history.revert()
    for(let i=arr.length-1; i>=0; i--){
      setPixel(arr[i][0],arr[i][1],false)
    }
  }
})
const tr = {}
keys.on.D.add((ev)=>{
  if(!tr.d)history.newBatch();
  tr.d = true;
})
keys.onup.D.add(()=>tr.d=false)
keys.on.S.add((ev)=>{
  if(!tr.s)history.newBatch();
  tr.s=true
})
keys.onup.S.add(()=>{tr.s=false; console.log("here")}) 
